﻿-----------------------------------------------------------------------------------
USE AdventureWorksOBP
GO
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-- Zadatak 1.
/*
KORISNIÈKI DEFINIRANI TABLIÈNI TIPOVI
Napišite proceduru koja dohvaæa sve kupce èiji ID-evi su proslijeðeni 
pomoæu korisnièki definiranog tabliènog tipa. 
*/
-- Kreiranje korisnièki definiranog tipa
CREATE TYPE MyKupac AS TABLE ( IDKupac int )
GO
-- Stvaranje procedure
CREATE PROC zad8
	@Kupci MyKupac READONLY
AS
SELECT * FROM dbo.Kupac WHERE IDKupac IN (SELECT * FROM @Kupci)
GO
-- Pozivanje procedure.
DECLARE @t MyKupac
INSERT INTO @t VALUES (1)
INSERT INTO @t VALUES (2)
INSERT INTO @t VALUES (3)
EXEC zad8 @t
GO
-----------------------------------------------------------------------------------

-----------------------------------------------------------------------------------
-- Zadatak 2.
/*
KORISNIÈKI DEFINIRANI TABLIÈNI TIPOVI
Napišite proceduru koja umeæe države proslijeðene 
pomoæu korisnièki definiranog tabliènog tipa. 
Pozovite proceduru.
*/
-- Kreiranje korisnièki definiranog tipa
CREATE TYPE MyDrzava AS TABLE ( Naziv nvarchar(50) )
GO
-- Stvaranje procedure
CREATE PROC zad9
	@Drzave MyDrzava READONLY
AS
INSERT INTO Drzava
SELECT * FROM @Drzave
GO
-- Pozivanje procedure.
DECLARE @t MyDrzava
INSERT INTO @t VALUES ('Indija')
INSERT INTO @t VALUES ('Pakistan')
INSERT INTO @t VALUES ('Bangladeš')
EXEC zad9 @t
GO
select * from drzava
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-- Zadatak 3.
/*
KORISNIÈKI DEFINIRANI TABLIÈNI TIPOVI
Napišite proceduru koja umeæe potkategorije proslijeðene 
pomoæu korisnièki definiranog tabliènog tipa. 
Umetnuti samo onu potkategoriju koja ne postoji u tablici 
(ako postoji nemojte umetati ponovno). 
Pozovite proceduru.
*/
-- Kreiranje korisnièki definiranog tipa
CREATE TYPE MyPotkategorija AS TABLE ( KategorijaID int, Naziv nvarchar(50) )
GO
-- Stvaranje procedure
CREATE PROC zad10
	@Potk MyPotkategorija READONLY
AS
INSERT INTO Potkategorija
SELECT KategorijaID, Naziv FROM @Potk WHERE Naziv NOT IN (SELECT Naziv FROM Potkategorija)
GO
-- Pozivanje procedure.
DECLARE @t MyPotkategorija
INSERT INTO @t VALUES (1, 'Mountain Bikes')
INSERT INTO @t VALUES (1, 'Ninja Bikes')
EXEC zad10 @t
GO

select * from Potkategorija
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-- Zadatak 4.
/*
Napisati proceduru koja prima JSON dokument oblika:

{"OSOBE":
	[
		{"OSOBA":
			{"ime": "Pero", "prezime": "Perić"}},
		{"OSOBA":
			{"ime": "Iva", "prezime": "Ivić"}} 	]
}
 
Neka procedura vrati tablicu s imenima i prezimenima osoba. 
Pozvati proceduru s gornjim parametrom.
*/

create proc p11
	@json nvarchar(max)
as
select ime, prezime
from openjson(@json, '$.OSOBE')		
with		
(
	Ime nvarchar(50) '$.OSOBA.ime',
	Prezime nvarchar(50) '$.OSOBA.prezime'
)


declare @json nvarchar(max)
set @json= 
'{"OSOBE":	
		[
			{"OSOBA":
					{
						"ime": "Pero",	
						"prezime": "Perić"
					}
			},
			{"OSOBA":
					{
						"ime": "Iva",	
						"prezime": "Ivić"
					}
			}
		]}'

exec p11 @json
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-- Zadatak 5.
/*
Napisati proceduru koja prima JSON dokument oblika:

N‘ { "OSOBE":
	[ { "OSOBA":
		{ "idosoba": 2,  "ime": "Iva",  "prezime": "Ivić",  "ostalo": 
			{"email": "iva.ivic@algebra.hr", "telefon": "091 222 3333” } } } ] } '

Neka procedura vrati tablicu s imenima, prezimenima i telefonskim brojevima osoba. 
Pozvati proceduru s gornjim parametrom.
*/

create proc p12
	@json nvarchar(max)
as
select ime, prezime, telefon
from openjson(@json, '$.OSOBE')		
with		
(
	Ime nvarchar(50) '$.OSOBA.ime',
	Prezime nvarchar(50) '$.OSOBA.prezime',
	Telefon nvarchar(50) '$.OSOBA.ostalo.telefon'
)
go

declare @json nvarchar(max)
set @json= 
N'{"OSOBE":	
		[
			{"OSOBA":
					{"idosoba": 2,
					 "ime": "Iva",	
					 "prezime": "Ivić",			
					 "ostalo": 
						{"email": "iva.ivic@algebra.hr", 
						 "telefon": "091 222 3333"}}}]}'
exec p12 @json
-----------------------------------------------------------------------------------
-----------------------------------------------------------------------------------
-- Zadatak 6.
/*
Napišite upit kojim ćete s podacima IDKupac, Ime, Prezime, Email i Telefon iz tablice Kupac 
kreirati JSON dokument oblika kako je prikazano niže, za sve kupce koji imaju IDKupac<11:
{"OSOBE":
	[
	{"OSOBA":
		{"idkupac":1,"ime":"Gustavo","prezime":"Achong",
			"ostalo":{"email":"gustavo0@adventure-works.com","telefon":"398-555-0132"}}}
	]}
*/
select k.IDKupac as [OSOBA.idkupac], k.Ime as [OSOBA.ime], k.prezime as [OSOBA.prezime],
email as [OSOBA.ostalo.email],
telefon as [OSOBA.ostalo.telefon]
from Kupac as k
where k.IDKupac<11
for json path, root('OSOBE')